#!/bin/bash

# ==========================================
# CONFIGURACIÓN DE COLORES Y ESTILO
# ==========================================
RED='\033[0;31m'
GREEN='\033[0;32m'
BLUE='\033[0;34m'
CYAN='\033[0;36m'
YELLOW='\033[1;33m'
NC='\033[0m' # No Color

# Función para mostrar el banner
show_banner() {
    clear
    echo -e "${CYAN}"
    echo "   ____                                         __  __       _ _       "
    echo "  / ___| ___ _ __ _ __ ___   __ _ _ __         |  \/  | __ _| | | ___  "
    echo " | |  _ / _ \ '__| '_ \` _ \ / _\` | '_ \ _____  | |\/| |/ _\` | | |/ _ \ "
    echo " | |_| |  __/ |  | | | | | | (_| | | | |_____| | |  | | (_| | | | (_) |"
    echo "  \____|\___|_|  |_| |_| |_|\__,_|_| |_|       |_|  |_|\__,_|_|_|\___/ "
    echo -e "${NC}"
    echo -e "${YELLOW}            >>> VISITA: GERMANMALLO.COM <<<            ${NC}"
    echo -e "${BLUE}        Automated Dev Environment Setup Script v1.0        ${NC}"
    echo "==================================================================="
    echo ""
    sleep 2
}

# Función de log con estilo
log() {
    echo -e "${GREEN}[+]${NC} $1"
}

warn() {
    echo -e "${YELLOW}[!]${NC} $1"
}

# ==========================================
# INICIO DEL SCRIPT
# ==========================================

show_banner

echo -e "🚀 ${BLUE}Iniciando la secuencia de instalación...${NC}"
echo -e "⚠️  Se solicitará tu contraseña de administrador (sudo) una vez."
sudo -v

# Mantiene el sudo vivo
while true; do sudo -n true; sleep 60; kill -0 "$$" || exit; done 2>/dev/null &

# 1. ACTUALIZACIÓN
log "Actualizando repositorios y sistema..."
sudo apt update && sudo apt upgrade -y

# 2. HERRAMIENTAS BASE
log "Instalando herramientas esenciales (Git, Curl, Zsh, Build-utils)..."
sudo apt install -y git curl wget build-essential htop zsh software-properties-common ca-certificates gnupg lsb-release

# 3. PYTHON & DATA SCIENCE
log "Configurando entorno Python, IA y Ciencia de Datos..."
sudo apt install -y python3-pip python3-venv python3-dev
pip3 install --upgrade pip --quiet

# 4. DOCKER (INSTALACIÓN OFICIAL)
log "Comprobando Docker..."
if ! command -v docker &> /dev/null
then
    warn "Docker no detectado. Instalando desde repositorios oficiales..."
    curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo gpg --dearmor -o /usr/share/keyrings/docker-archive-keyring.gpg
    echo "deb [arch=$(dpkg --print-architecture) signed-by=/usr/share/keyrings/docker-archive-keyring.gpg] https://download.docker.com/linux/ubuntu $(lsb_release -cs) stable" | sudo tee /etc/apt/sources.list.d/docker.list > /dev/null
    sudo apt update
    sudo apt install -y docker-ce docker-ce-cli containerd.io
    sudo usermod -aG docker $USER
    log "Docker instalado correctamente."
else
    log "Docker ya estaba instalado."
fi

# 5. FULL STACK (NODE VIA NVM)
log "Instalando NVM y Node.js (LTS)..."
export NVM_DIR="$HOME/.nvm"
# Instalamos/Actualizamos NVM
curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.5/install.sh | bash
# Cargamos NVM en esta sesión para usarlo ahora
[ -s "$NVM_DIR/nvm.sh" ] && \. "$NVM_DIR/nvm.sh"
# Instalamos Node LTS
nvm install --lts

log "Instalando VS Code..."
sudo snap install code --classic

# 6. BASES DE DATOS
log "Desplegando Motores de Bases de Datos (Postgres, Redis)..."
sudo apt install -y postgresql postgresql-contrib redis-server
log "Instalando DBeaver (Cliente SQL)..."
sudo snap install dbeaver-ce

# 7. APPS PRODUCTIVIDAD Y OCIO
log "Instalando aplicaciones de escritorio (Spotify, Discord, Thunderbird)..."
sudo snap install spotify
sudo snap install discord
sudo apt install -y thunderbird

# 8. LIMPIEZA
log "Limpiando paquetes residuales..."
sudo apt autoremove -y

# ==========================================
# FINALIZACIÓN
# ==========================================
echo ""
echo "==================================================================="
echo -e "${GREEN}✅  ¡INSTALACIÓN COMPLETADA CON ÉXITO!  ✅${NC}"
echo "==================================================================="
echo -e "🔹 Python, Node, Docker y tus Apps están listas."
echo -e "🔹 ${YELLOW}NOTA IMPORTANTE:${NC} Reinicia el equipo o cierra sesión para aplicar los grupos de Docker."
echo ""
echo -e "${CYAN}Programado por:${NC} German Mallo"
echo -e "${CYAN}Web:${NC} https://germanmallo.com"
echo ""
